\NeedsTeXFormat{pLaTeX2e}
%\@obsoletefile{jarticle.cls}{JCSS.sty}
%基本部分はjarticleを使用
\LoadClass[10pt,a4j,twocolumn,notitlepage]{jarticle}
%任意のフォントサイズの設定
%\usepackage{type1cm}

%!!! ページ設定変更 (2015/06/11 YD)
%ページ設定(デフォルト：A4サイズ、1行24字＊46行)
%行送り(行数/ページ)の設定
%\renewcommand{\baselinestretch}{1}
%字送り(文字数/行)の設定 (10pt)
\kanjiskip=0zw plus .1zw minus .01zw
\xkanjiskip=0.25em plus 0.15em minus 0.06em
%ページ設定
\paperwidth 210mm%用紙の幅
\paperheight 297mm%用紙の高さ
\voffset -1in%垂直方向のオフセット
\hoffset -1in%水平方向のオフセット
\topmargin 25mm%オフセットからヘッダまでのマージン
\headheight 0mm%ヘッダの高さ
\headsep 0mm%ヘッダと本文領域の間の高さ
\topskip 0mm%本文領域内の本文開始位置までの高さ
\textheight 46\baselineskip%文章領域の高さ
\oddsidemargin 20mm%奇数ページのマージン
\evensidemargin\oddsidemargin%偶数ページのマージン
\columnwidth 24.1zw%コラムの幅
\columnsep 2zw%コラム間の幅
\textwidth 50.2zw%文章領域の幅 (24.1＊2 + 2)

%キャプション位置
\setlength\abovecaptionskip{0zw}
\setlength\belowcaptionskip{.5zw}


%タイトルの出力
%!!! 行間変更 (2015/06/08 YD)
\def\@maketitle{%
  \newpage\null
  \begin{center}
  \let\footnote\thanks
   {\fontsize{16pt}{0pt}\selectfont {\bfseries \@title }\par}
   {\fontsize{16pt}{18pt}\selectfont {\bfseries \@etitle }\par}
    \vskip 1zh
    {\large
     \lineskip .5zh
     \@author \par
     \@eauthor \par}%
    \vskip .5zh
    \@affiliation \par
    \@eaffiliation \par
    \@email %
  \end{center}%
  \par\vskip 2zh}

%英語タイトル
\def\etitle#1{\gdef\@etitle{#1}}
%英語著者
\def\eauthor#1{\gdef\@eauthor{#1}}
%著者の所属
\def\affiliation#1{\gdef\@affiliation{#1}}
%英語所属
\def\eaffiliation#1{\gdef\@eaffiliation{#1}}
%メールアドレス
\def\email#1{\gdef\@email{#1}}
%アブストラクト
\def\abstract#1{\gdef\@abstract{#1}}
%キーワード
\def\keywords#1{\gdef\@keywords{#1}}

%アブストラクト、キーワード出力
\newcommand{\makeabstract}{%
      \section*{概要}%
      \@abstract \\%
      {\bfseries キーワード：%
      \@keywords%
      }%
}%

%アブストラクト、キーワード出力
\newcommand{\makeabstractenglish}{%
      \section*{Abstract}%
      \@abstract \\%
      {\bfseries キーワード：%
      \@keywords%
      }%
}%

%セクションの設定
\def\section{\@startsection {section}{1}{\z@}{1zw plus 1ex minus .2ex}{.1ex plus .2ex}{\large\bf}}
%セクション番号後にピリオド
\renewcommand{\thesection}{\@arabic\c@section .}
\renewcommand{\thesubsection}{\thesection\@arabic\c@subsection }
\renewcommand{\thesubsubsection}{\thesubsection.\@arabic\c@subsubsection }

%!!! 箇条書きの行間変更 (2015/06/11 YD)
\renewcommand\@listi{%
  \leftmargin\leftmargini
  \parsep\z@
  \topsep\z@
  \itemsep\z@}
\let\@listI\@listi
\@listi

%番号付き箇条書きの設定
\renewenvironment{enumerate}
  {
  \ifnum \@enumdepth >\thr@@\@toodeep\else
   \advance\@enumdepth\@ne
   \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
   \list{\csname label\@enumctr\endcsname}{%
      \iftdir
         \ifnum \@listdepth=\@ne \topsep\z@
           \else\topsep\z@\fi
         \labelwidth1zw \labelsep.3zw
         \ifnum \@enumdepth=\@ne \leftmargin1zw\relax
           \else\leftmargin\leftskip\fi
         \advance\leftmargin 1zw
      \fi
         \parskip-1.zw \itemsep\z@ \parsep\z@
         \usecounter{\@enumctr}%
         \def\makelabel##1{\hss\llap{##1}}}%
   \fi 
   }{\endlist}

%項目箇条書きの設定
\renewenvironment{itemize}
  {
  \ifnum \@itemdepth >\thr@@\@toodeep\else
   \advance\@itemdepth\@ne
   \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
   \expandafter
   \list{\csname \@itemitem\endcsname}{%
      \iftdir
         \ifnum \@listdepth=\@ne \topsep\z@
           \else\topsep\z@\fi
         \labelwidth1zw \labelsep.3zw
         \ifnum \@itemdepth =\@ne \leftmargin1zw\relax
           \else\leftmargin\leftskip\fi
         \advance\leftmargin 1zw
      \fi
         \parskip-1.zw \itemsep\z@ \parsep\z@ \partopsep\z@  
         \def\makelabel##1{\hss\llap{##1}}}%
   \fi }{\endlist}

%見出し付き箇条書きの設定
\renewenvironment{description}
  {\list{}{\labelwidth\z@ \itemindent-\leftmargin
   \iftdir
     \leftmargin\leftskip \advance\leftmargin3\Cwd
     \rightmargin\rightskip
     \labelsep=1zw 
   \fi
   \itemsep\z@
     \listparindent\z@ \topskip\z@ \parskip-1.zw \partopsep\z@
           \let\makelabel\descriptionlabel}}{\endlist}         

%参考文献の設定
%!!! Headingの下の行間調整 (2015/06/11 YD)
\renewenvironment{thebibliography}[1]
{
\section*{\refname\@mkboth{\refname}{\refname}}%
   \list{\@biblabel{\@arabic\c@enumiv}}%
        {\settowidth\labelwidth{\@biblabel{#1}}%
         \leftmargin\labelwidth
         \labelwidth1zw \labelsep.3zw 
         \advance\leftmargin\labelsep
         \@openbib@code
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}
         \parskip-.5zw \itemsep\z@ \parsep\z@ \small
         \vskip 1zw}%
   \sloppy
   \clubpenalty4000
   \@clubpenalty\clubpenalty
   \widowpenalty4000%
   \sfcode`\.\@m}
  {\def\@noitemerr
    {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist \vspace{-.5zw}}

%図表番号の設定
%!!! 図表番号の後の空白変更 (2015/06/11 YD)  
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \iftdir\sbox\@tempboxa{#1\hskip1zw#2}%
    \else\sbox\@tempboxa{#1\hskip1zw#2}%
  \fi
  \ifdim \wd\@tempboxa >\hsize
    \iftdir #1\hskip1zw#2\relax\par
      \else #1\hskip1zw#2\relax\par\fi
  \else
    \global \@minipagefalse
    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
